﻿using System;
using System.Threading;

/// +------------------------------------------------------------------------------------------------------------------------------+
/// |                                                   TERMS OF USE: MIT License                                                  |
/// +------------------------------------------------------------------------------------------------------------------------------|
/// |Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    |
/// |files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    |
/// |modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software|
/// |is furnished to do so, subject to the following conditions:                                                                   |
/// |                                                                                                                              |
/// |The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.|
/// |                                                                                                                              |
/// |THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          |
/// |WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         |
/// |COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   |
/// |ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         |
/// +------------------------------------------------------------------------------------------------------------------------------+

namespace IRSkyBBB
{
    class MainClass
    {
        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Program Main Loop. It all starts here
        /// </summary>
        /// <history>
        ///   20 Jan 14  Cynic - originally written
        /// </history>
        public static void Main (string[] args)
        {
            Console.WriteLine ("IRSkyBBB Starts");

            // call the test routine
            TestSkyPlusIRDecoder();

            Console.WriteLine ("IRSkyBBB Ends");
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Tests the SKY+ IR decoder routines. Never Leaves here. Expects a specific 
        /// hardware setup as discussed below.
        /// 
        /// Hardware:
        ///   Beaglebone Black RevC with mono installed
        ///   Sparkfun IR Receiver Breakout SEN-08554 configured on pin Pins.GPIO_PIN_D7
        ///   Sky+ IR Remote with TV mode configured for a Phillips TV
        /// Optional Hardware:
        ///   Sparkfun 7-Segment Serial Display COM-11441 configured for SPI on GPIO_PIN_D9
        ///   Sparkfun 7-Segment Serial Display COM-11441 configured for SPI on GPIO_PIN_D10
        /// 
        /// </summary>
        /// <history>
        ///   20 Jan 14  Cynic - originally written
        /// </history>
        public static void TestSkyPlusIRDecoder()
        {
            // this contains the information we write to the 7 Segment displays
            int lastDiagnosticValue = -1;

            // create a new decoder app class, the Sparkfun IR Receiver Breakout is on the pin
            // in the constructor call
            RC6RC5Decoder rc6rc5Decoder = new RC6RC5Decoder(BBBCSIO.GpioEnum.GPIO_49, BBBCSIO.InterruptMode.InterruptEdgeBoth);

            while (true)
            {
                // we do not want to be continuously processable
                Thread.Sleep(100);

                // display some diagnostic information. I like to output
                // the ResetCount. This is the total number of signal packets including
                // the discarded ones. It is amazing how much garbage signal the decoder
                // has to chuck out in between the real signals. Mostly it is fluorescent
                // lights kicking out all sorts of stray IR
                int diagnosticValue = rc6rc5Decoder.ResetCount;
                if (diagnosticValue != lastDiagnosticValue) 
                {
					Console.WriteLine ("Total Codes: " + diagnosticValue.ToString ());
                    lastDiagnosticValue = diagnosticValue;
                }

                // have we got any data?
                if (rc6rc5Decoder.IsDataAvailable() == true)
                {
                    // get the data
                    int irCode = rc6rc5Decoder.GetData();
                    Console.WriteLine ("IRCode " + irCode.ToString("X4"));

                }
            }
        }

    }
}
