using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

/// +------------------------------------------------------------------------------------------------------------------------------+
///                                                    TERMS OF USE: MIT License                                                  
/// +------------------------------------------------------------------------------------------------------------------------------
/// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    
/// files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    
/// modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
/// is furnished to do so, subject to the following conditions:                                                                   
///                                                                                                                               
/// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
///                                                                                                                               
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          
/// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         
/// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   
/// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         
/// +------------------------------------------------------------------------------------------------------------------------------+

namespace PropScriptBitInspector
{
    /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
    /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
    /// <summary>
    /// A control which displays the split out components of a PASM instruction
    /// </summary>
    /// <history>
    ///    10 Apr 09  Cynic - Started
    /// </history>
    public partial class ctlDisplayINSTR : UserControl
    {
        public bool DEFAULT_ADDRFIELD_VISIBLE = true;
         
        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Constructor
        /// </summary>
        /// <history>
        ///    10 Apr 09  Cynic - Started
        /// </history>
        public ctlDisplayINSTR()
        {
            InitializeComponent();
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Gets/Sets wether the address field is visible
        /// </summary>
        /// <history>
        ///    11 Apr 09  Cynic - Started
        /// </history>
        public bool AddrFieldVisible
        {
            get
            {
                return this.textBoxLineNumber.Visible;
            }
            set
            {
                this.textBoxLineNumber.Visible = value;
                this.labelAddr.Visible = value;
            }
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Accepts 4 little endian bytes and sets the display
        /// </summary>
        /// <param name="lineNumber">The line number</param>
        /// <param name="byte0">The lowest byte to convert</param>
        /// <param name="byte1">The next byte to convert</param>
        /// <param name="byte2">The next byte to convert</param>
        /// <param name="byte3">The highest byte to convert</param>
        /// <history>
        ///    10 Apr 09  Cynic - Started
        /// </history>
        public void SetDisplay(int lineNumber, byte byte0, byte byte1, byte byte2, byte byte3)
        {
            int workingInt;

            string strINSTR="";
            string strZCRI="";
            string strCON="";
            string strDEST="";
            string strSRC="";
            string strCODE="";

            BinaryDataConverter.GetSplitOutPASMComponents(byte0, byte1, byte2, byte3, ref strCODE, ref strINSTR, ref strZCRI, ref strCON, ref strDEST, ref strSRC);
            this.textBoxCode.Text=strCODE;
            this.textBoxCON.Text=strCON;
            this.textBoxDEST.Text=strDEST;
            this.textBoxSRC.Text=strSRC;
            this.textBoxZCRI.Text=strZCRI;
            this.textBoxINSTR.Text=strINSTR;

            string strLineNumber = System.Convert.ToString(lineNumber, 16);
            strLineNumber = BinaryDataConverter.PadWithLeadingZeros(strLineNumber.ToUpper(), BinaryDataConverter.DEFAULT_PROGRAM_COUNTER_DIGITS);
            textBoxLineNumber.Text = strLineNumber;

            // now the secondary dest fields
            try
            {
                workingInt = Convert.ToInt32(textBoxDEST.Text, 2);
                textBoxDESTHex.Text = System.Convert.ToString(workingInt, 16);
                textBoxDESTAddr.Text = System.Convert.ToString(BinaryDataConverter.ConvertIntegerInPASMAddressFormatToAbsoluteAddress(workingInt), 16).ToUpper();
            }
            catch
            {
                textBoxDESTHex.Text = "?";
                textBoxDESTAddr.Text = "?";
            }
            // now the secondary src fields
            try
            {
                workingInt = Convert.ToInt32(textBoxSRC.Text, 2);
                textBoxSRCHex.Text = System.Convert.ToString(workingInt, 16);
                textBoxSRCAddr.Text = System.Convert.ToString(BinaryDataConverter.ConvertIntegerInPASMAddressFormatToAbsoluteAddress(workingInt), 16).ToUpper();
            }
            catch
            {
                textBoxSRCHex.Text = "?";
                textBoxSRCAddr.Text = "?";
            }
 
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Resets the visual elements of this control
        /// </summary>
        /// <history>
        ///    10 Apr 09  Cynic - Started
        /// </history>
        public void Reset()
        {
            this.textBoxCode.Text = "";
            this.textBoxCON.Text = "";
            this.textBoxDEST.Text = "";
            this.textBoxSRC.Text = "";
            this.textBoxZCRI.Text = "";
            this.textBoxINSTR.Text = "";
            this.textBoxLineNumber.Text = "";
        }
    }
}
