using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

/// +------------------------------------------------------------------------------------------------------------------------------+
///                                                    TERMS OF USE: MIT License                                                  
/// +------------------------------------------------------------------------------------------------------------------------------
/// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation    
/// files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,    
/// modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
/// is furnished to do so, subject to the following conditions:                                                                   
///                                                                                                                               
/// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
///                                                                                                                               
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE          
/// WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR         
/// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,   
/// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                         
/// +------------------------------------------------------------------------------------------------------------------------------+

namespace SRV1CSharpConsole
{
    /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
    /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
    /// <summary>
    /// A class to display the contents of the SRV1 flash buffer. Really just
    /// a rich text box and a button.
    /// </summary>
    /// <history>
    ///    28 Nov 08  Cynic - Originally written
    /// </history>
    public partial class frmSRV1FlashBufferCode : Form
    {
        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Default Constructor
        /// </summary>
        /// <param name="flashCode">The code to display</param>
        /// <history>
        ///    28 Nov 08  Cynic - Originally written
        /// </history>
        public frmSRV1FlashBufferCode()
        {
            InitializeComponent();
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="flashCode">The code to display</param>
        /// <history>
        ///    28 Nov 08  Cynic - Originally written
        /// </history>
        public frmSRV1FlashBufferCode(string flashCode)
        {
            InitializeComponent();

            if (flashCode != null)
            {
                richTextBoxFlashBufferCode.Text = flashCode;
            }
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Handles a click on the close button
        /// </summary>
        /// <history>
        ///    28 Nov 08  Cynic - Originally written
        /// </history>
        private void buttonClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// +=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
        /// <summary>
        /// Attempts to fixup the code returned from the SRV1 Flash buffer
        /// </summary>
        /// <history>
        ///    28 Nov 08  Cynic - Originally written
        /// </history>
        private void buttonLineFixup_Click(object sender, EventArgs e)
        {
            string tmpStr = richTextBoxFlashBufferCode.Text;
            if (tmpStr == null) return;
            // replace various things with linefeeds so the 
            // richtext box displays them on new lines
            tmpStr = tmpStr.Replace("{", "\n{\n");
            tmpStr = tmpStr.Replace("}", "\n}\n");
            tmpStr = tmpStr.Replace(";", ";\n");
            tmpStr = tmpStr.Replace(@"*/", @"*/"+"\n");
            richTextBoxFlashBufferCode.Text = tmpStr;
        }
    }
}